/*
 * Decompiled with CFR 0.152.
 */
package com.bosschongsheng;

import com.bosschongsheng.config.BossRespawnConfig;
import com.bosschongsheng.network.PacketOpenConfigScreen;
import com.bosschongsheng.network.XiangcaoNet;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="bosschongsheng", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BossRespawnEvents {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bosschongsheng").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"config").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            Entity patt1626$temp = ((CommandSourceStack)ctx.getSource()).m_81373_();
            if (patt1626$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt1626$temp;
                XiangcaoNet.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new PacketOpenConfigScreen());
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u4ec5\u73a9\u5bb6\u53ef\u6253\u5f00\u914d\u7f6e\u754c\u9762"));
            return 0;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").requires(cs -> cs.m_6761_(2))).executes(ctx -> {
            BossRespawnConfig.getInstance().reloadConfig();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237115_((String)"gui.bosschongsheng.config.reloaded"), true);
            return 1;
        })));
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Entity entity;
        EntityType entityType;
        if (event.getLevel().m_5776_()) {
            return;
        }
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ServerPlayer player = (ServerPlayer)event.getEntity();
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return;
        }
        String itemIdStr = itemId.toString();
        BlockPos pos = player.m_20183_();
        String structureId = BossRespawnEvents.getStructureAt(level2, pos);
        boolean isTriggerItem = BossRespawnConfig.getInstance().getRules().stream().anyMatch(r -> itemIdStr.equals(r.triggerItemId));
        if (isTriggerItem) {
            LOGGER.info("[BossChongsheng] \u53f3\u952e \u89e6\u53d1\u7269\u54c1={} \u4f4d\u7f6e={} \u68c0\u6d4b\u5230\u7ed3\u6784={}", new Object[]{itemIdStr, pos.m_123344_(), structureId != null ? structureId : "\u65e0\uff08\u8bf7\u786e\u8ba4\u7ad9\u5728\u7ed3\u6784\u5185\u90e8\uff09"});
        }
        if (LOGGER.isDebugEnabled() && !isTriggerItem) {
            LOGGER.debug("[BossChongsheng] \u53f3\u952e \u7269\u54c1={} \u4f4d\u7f6e={} \u68c0\u6d4b\u5230\u7ed3\u6784={}", new Object[]{itemIdStr, pos.m_123344_(), structureId != null ? structureId : "\u65e0"});
        }
        if (structureId == null) {
            return;
        }
        BossRespawnConfig.BossRespawnRule rule = BossRespawnConfig.getInstance().getRule(structureId);
        if (rule == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[BossChongsheng] \u7ed3\u6784 {} \u65e0\u5bf9\u5e94\u89c4\u5219", (Object)structureId);
            }
            return;
        }
        if (!itemIdStr.equals(rule.triggerItemId)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("[BossChongsheng] \u7269\u54c1\u4e0d\u5339\u914d \u5f53\u524d={} \u89c4\u5219\u8981\u6c42={}", (Object)itemIdStr, (Object)rule.triggerItemId);
            }
            return;
        }
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        if ((entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)rule.entityTypeId))) != null && (entity = entityType.m_20615_((Level)level2)) != null) {
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, player.m_146908_(), 0.0f);
            level2.m_7967_(entity);
            LOGGER.info("[BossChongsheng] \u5728\u7ed3\u6784 {} \u5185\u4f7f\u7528 {} \u53ec\u5524 {}", new Object[]{structureId, itemIdStr, rule.entityTypeId});
        }
    }

    private static String getStructureAt(ServerLevel level, BlockPos pos) {
        StructureManager structureManager = level.m_215010_();
        for (BossRespawnConfig.BossRespawnRule rule : BossRespawnConfig.getInstance().getRules()) {
            ResourceKey rk;
            StructureStart start;
            ResourceLocation key = ResourceLocation.m_135820_((String)rule.structureId);
            if (key == null || (start = structureManager.m_220488_(pos, rk = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)key))) == null || !start.m_73603_()) continue;
            return rule.structureId;
        }
        return null;
    }
}

